--The scripts should always contain at least 10 functions :ScriptID, DisplaySourceName(), SourceSuperClassID(), SourceClassID(), DisplayDestinationName() DestinationSuperClassID(), DestinationClassID(), AboutText() and DefaultConversion, Conversion taking a param.
--Script ID that will append to destination
fn ScriptID = 
(
	""
)

--Return the name to be display for the source in the Scene Converter UI
fn DisplaySourceName =
(
	#(~SKYLIGHT~, ~IES_SKY~, ~MRAY_PHYS_SKY~)
)

--Returns the source class of the super class id 
fn SourceSuperClassID =
(
	#(48, 48, 48) --Light
)

--Returns the class id of the source class we use as a source for conversion
fn SourceClassID =
(
	#(#(0x7bf61478L, 0x522e4705L)/*Skylight*/, #(0x4b241b11L, 0x64e8527dL)/*IES_Sky*/, #(0x26ee3350L, 0x799b5b56L)/*mr_Sky*/)
)

--Return the name to be display for the destination in the Scene Converter UI - must be in the order than the destination class ids
fn DisplayDestinationName =
(
	~PHYSICAL_SKY~
)

--Returns the destination class of the super class id
fn DestinationSuperClassID =
(
	3088 --Texmap 
)

--Returns the class id of the class we use as a destination for conversion
-- so we convert from SourceClassID() to DestinationClassID()
fn DestinationClassID =
(
	#(0x223349b4L, 0x562a7d8bL) --Physical Sky
)

--Validate that the source provided match with one of the SourceClass
fn VerifySource source =
(
	local ret = false	
	local src = SourceClassID()
	
	if(source == undefined) do return false
	
	if(classof src[1] == Array) then
    (
		for cd in src do
		(
			if((cd as string) == (source.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((src as string) == (source.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Validate that the destination provided match with one of the DestinationClass
fn VerifyDestination destination =
(
	local ret = false	
	local dest = DestinationClassID()

	if(destination == undefined) do return false
	
	if(classof dest[1] == Array) then
    (
		for cd in dest do
		(
			if((cd as string) == (destination.ClassID as string)) do
			(
				ret = true
			)
		)
	)
    else
	(
		if((dest as string) == (destination.ClassID as string)) do
		(
			ret = true
		)
	)
    ret 
)

--Returns some information about this conversion script
fn AboutText =
(
	~ABOUT_TEXT~
)

--This internal function does the parameter mapping
fn ConvertFromSkyLightToPhysicalSky legacySkyLight physSky =
(
	if ((false == VerifySource legacySkyLight) or 
		(false == VerifyDestination physSky)
		) do
	(
		--Not the suitable nodes
		return undefined
	)	
)

fn InstallPhysicalSunAndSkyEnvMap =
(
--The code that install the environmap in the sun positioner, also configure the Exposure control, I don't know if this should also be done here.
--I am currently assuming that the exposure control will be set per another script.

	--Check if Physical Sun and Sky environment map is not already configured... 
	if ((environmentMap == undefined) or 
		((environmentMap.classid as string) != (Physical_Sun___Sky_Environment.classid as string))) do
	( -- if not, configure a new map
	--Don't know if this need to be local variable need to be global or local
		physSunSkyEnv = Physical_Sun___Sky_Environment name:Physical_Sun___Sky_Environment.localizedName --Not sure if it is the correct name	
		environmentMap = physSunSkyEnv 
		useEnvironmentMap = true
	) 
	
	--Note: this does not set a sun positioner.

	environmentMap
)

--This function is use as entry when the source is missing (due to a missing plugin) and cannot be completly loaded. 
--In that case the default parameters are loaded.
fn DefaultConversion source /*not use*/ =
(
	local physSky = InstallPhysicalSunAndSkyEnvMap()
		
	--return the environment map
	physSky	
)

--Main entry point from this script
--This function handles the creation of the sky if necessary, and transfer from the skylight to the environment map.
fn Conversion legacySkylight =
(
	if (false == VerifySource legacySkylight)  do
	(
		--Not the suitable node
		return undefined
	)	
	
	local physSky = InstallPhysicalSunAndSkyEnvMap()
	
	ConvertFromSkyLightToPhysicalSky legacySkylight physSky
	
	if (IsProperty legacySkylight "name") and (undefined != legacySkylight.name) and (String == classof legacySkylight.name)  and (IsProperty physSky "name") do
    (
        physSky.name = legacySkylight.name
    )
    
	--return the environment map
	physSky	
)